/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.resourcestab;

import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.api.VWScenarioResourceDefinition;
import filenet.sim.toolkit.designer.properties.IVWSIMPropertyChangeListener;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyChangeEvent;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.sim.toolkit.designer.properties.resourcestab.VWSIMAssignedShiftsPanel;
import filenet.sim.toolkit.designer.properties.resourcestab.VWSIMResourcesTableModel;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWSplitPane;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import filenet.vw.toolkit.utils.uicontrols.textfield.VWNumericTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.Document;

public class VWSIMResourcesPropertiesTab
extends JPanel
implements DocumentListener,
ActionListener,
IVWSIMPropertyChangeListener,
ListSelectionListener,
TableModelListener,
IVWToolbarBorderActionListener {
    private VWToolbarBorder m_resourcesBorder = null;
    private VWTable m_resourcesTable = null;
    private VWSIMResourcesTableModel m_resourcesTableModel = null;
    private JPanel m_propertyPanel = null;
    private JComboBox m_typeComboBox = null;
    private VWNumericTextField m_quantityTextField = null;
    private VWNumericTextField m_costTextField = null;
    private VWSIMAssignedShiftsPanel m_assignedShiftsPanel = null;
    private VWSIMPropertyData m_propertyData = null;

    public void init(VWSIMPropertyData propertyData) {
        this.m_propertyData = propertyData;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.initTableControls();
        this.initPropertyControls();
        Locale browserLocale = this.m_propertyData.getSessionInfo().getBrowserLocale();
        ComponentOrientation compOrientation = null;
        compOrientation = browserLocale != null ? ComponentOrientation.getOrientation(browserLocale) : ComponentOrientation.LEFT_TO_RIGHT;
        if (compOrientation.isLeftToRight()) {
            VWSplitPane splitPane = new VWSplitPane(1, this.m_resourcesBorder, this.m_propertyPanel);
            splitPane.setToolTipText(VWSIMResource.s_splitterToolTip);
            splitPane.setDividerLocation(0.2);
            splitPane.setDividerSize(6);
            splitPane.setResizeWeight(0.5);
            this.add((Component)splitPane, "Center");
        } else {
            VWSplitPane splitPane = new VWSplitPane(1, this.m_propertyPanel, this.m_resourcesBorder);
            splitPane.setToolTipText(VWSIMResource.s_splitterToolTip);
            splitPane.setDividerLocation(0.7);
            splitPane.setDividerSize(6);
            splitPane.setResizeWeight(0.5);
            this.add((Component)splitPane, "Center");
        }
        this.reinitialize();
        this.m_propertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
    }

    public void releaseReferences() {
    }

    public void changedUpdate(DocumentEvent e) {
        Document doc = e.getDocument();
        if (doc == this.m_quantityTextField.getDocument()) {
            this.updateQuantityTextField();
        } else if (doc == this.m_costTextField.getDocument()) {
            this.updateCostTextField();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.m_typeComboBox) {
            this.performTypeComboBoxAction();
        }
    }

    public void propertyDataChanged(VWSIMPropertyChangeEvent event) {
        switch (event.getID()) {
            case 101: {
                this.reinitialize();
                break;
            }
            case 103: {
                this.m_resourcesTable.stopEditing();
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        try {
            if (!event.getValueIsAdjusting()) {
                this.m_resourcesBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_resourcesBorder.getClientPanel(), 2, Integer.MAX_VALUE));
                this.m_resourcesBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_resourcesBorder.getClientPanel(), 1, 65536));
                this.m_resourcesBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_resourcesBorder.getClientPanel(), 1, 16));
                int nSelectedRow = this.m_resourcesTable.getSelectedRow();
                int nType = -1;
                int nQuantity = 0;
                double dCost = 0.0;
                if (this.m_resourcesTableModel != null) {
                    if (nSelectedRow != -1) {
                        this.m_resourcesBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_resourcesBorder.getClientPanel(), 1, Integer.MAX_VALUE));
                    }
                    nType = (Integer)this.m_resourcesTableModel.getValueAt(nSelectedRow, 1);
                    nQuantity = (Integer)this.m_resourcesTableModel.getValueAt(nSelectedRow, 2);
                    dCost = (Double)this.m_resourcesTableModel.getValueAt(nSelectedRow, 3);
                }
                if (this.m_typeComboBox != null) {
                    this.m_typeComboBox.setEnabled(true);
                    this.m_typeComboBox.removeActionListener(this);
                    switch (nType) {
                        case 1: {
                            this.m_typeComboBox.setSelectedItem(VWSIMResource.s_participant);
                            this.m_quantityTextField.setEnabled(false);
                            break;
                        }
                        case 3: {
                            this.m_typeComboBox.setSelectedItem(VWSIMResource.s_workgroup);
                            this.m_quantityTextField.setEnabled(true);
                            break;
                        }
                        case 2: {
                            this.m_typeComboBox.setSelectedItem(VWSIMResource.s_system);
                            this.m_quantityTextField.setEnabled(true);
                        }
                    }
                    this.m_typeComboBox.addActionListener(this);
                }
                if (this.m_quantityTextField != null) {
                    this.m_quantityTextField.getDocument().removeDocumentListener(this);
                    this.m_quantityTextField.setText("" + nQuantity);
                    this.m_quantityTextField.getDocument().addDocumentListener(this);
                }
                if (this.m_costTextField != null) {
                    this.m_costTextField.setEnabled(true);
                    this.m_costTextField.getDocument().removeDocumentListener(this);
                    this.m_costTextField.setText("" + dCost);
                    this.m_costTextField.getDocument().addDocumentListener(this);
                }
                if (this.m_assignedShiftsPanel != null) {
                    VWScenarioResourceDefinition resourceDef = this.m_resourcesTableModel.getItemAt(nSelectedRow);
                    this.m_assignedShiftsPanel.setResourceDefinition(resourceDef);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int row = event.getLastRow() - 1;
                if (row < 0) {
                    row = 0;
                }
                if (row == this.m_resourcesTable.getSelectedRow()) {
                    this.m_resourcesTable.clearSelection();
                }
                if (row >= 0 && this.m_resourcesTableModel.getRowCount() > 0) {
                    this.m_resourcesTable.setRowSelectionInterval(row, row);
                }
                this.updateTableToolbar();
            }
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            switch (event.getID()) {
                case 16: {
                    this.m_resourcesTableModel.addItem();
                    break;
                }
                case 64: {
                    int nSelectedRow = this.m_resourcesTable.getSelectedRow();
                    this.m_resourcesTableModel.copyItem(nSelectedRow);
                    break;
                }
                case 0x10000000: {
                    int nSelectedRow = this.m_resourcesTable.getSelectedRow();
                    this.m_resourcesTableModel.deleteItem(nSelectedRow);
                    if (this.m_resourcesTableModel.getRowCount() != 0) break;
                    this.m_costTextField.setEnabled(false);
                    this.m_quantityTextField.setEnabled(false);
                    this.m_typeComboBox.setEnabled(false);
                    this.m_assignedShiftsPanel.setResourceDefinition(null);
                    break;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initTableControls() {
        this.m_resourcesBorder = new VWToolbarBorder(VWSIMResource.s_resourcesString, 0x10000050);
        this.m_resourcesBorder.addToolbarBorderActionNotifier(this);
        JPanel resourcesPanel = this.m_resourcesBorder.getClientPanel();
        resourcesPanel.setLayout(new GridLayout());
        this.m_resourcesTableModel = new VWSIMResourcesTableModel(this.m_propertyData);
        this.m_resourcesTableModel.addTableModelListener(this);
        this.m_resourcesTable = new VWTable(this.m_resourcesTableModel);
        this.m_resourcesTable.setRowSelectionAllowed(true);
        this.m_resourcesTable.getSelectionModel().addListSelectionListener(this);
        this.m_resourcesTable.getSelectionModel().setSelectionMode(0);
        this.m_resourcesTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
        this.m_resourcesTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
        resourcesPanel.add(new JScrollPane(this.m_resourcesTable));
        this.updateTableToolbar();
    }

    private void initPropertyControls() {
        this.m_propertyPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.fill = 0;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.anchor = 23;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.insets = new Insets(9, 5, 5, 5);
        this.m_propertyPanel.add((Component)new JLabel(VWSIMResource.s_colon.toString(VWSIMResource.s_resourceType)), gbCons);
        this.m_typeComboBox = new JComboBox();
        this.m_typeComboBox.setEnabled(false);
        this.m_typeComboBox.addItem(VWSIMResource.s_participant);
        this.m_typeComboBox.addItem(VWSIMResource.s_workgroup);
        this.m_typeComboBox.addItem(VWSIMResource.s_system);
        this.m_typeComboBox.setRenderer(new VWLabelListCellRenderer());
        this.m_typeComboBox.addActionListener(this);
        ++gbCons.gridx;
        gbCons.fill = 2;
        gbCons.weightx = 1.0;
        gbCons.insets = new Insets(5, 5, 5, 5);
        this.m_propertyPanel.add((Component)this.m_typeComboBox, gbCons);
        gbCons.gridx = 0;
        ++gbCons.gridy;
        gbCons.fill = 0;
        gbCons.weightx = 0.0;
        gbCons.insets = new Insets(9, 5, 5, 5);
        this.m_propertyPanel.add((Component)new JLabel(VWSIMResource.s_colon.toString(VWSIMResource.s_quantity)), gbCons);
        this.m_quantityTextField = new VWNumericTextField(4, 0, false);
        this.m_quantityTextField.setEnabled(false);
        this.m_quantityTextField.getDocument().addDocumentListener(this);
        ++gbCons.gridx;
        gbCons.fill = 2;
        gbCons.weightx = 1.0;
        gbCons.insets = new Insets(5, 5, 5, 5);
        this.m_propertyPanel.add((Component)this.m_quantityTextField, gbCons);
        gbCons.gridx = 0;
        ++gbCons.gridy;
        gbCons.fill = 0;
        gbCons.weightx = 0.0;
        gbCons.insets = new Insets(9, 5, 5, 5);
        this.m_propertyPanel.add((Component)new JLabel(VWSIMResource.s_colon.toString(VWSIMResource.s_costHour)), gbCons);
        this.m_costTextField = new VWNumericTextField(10, 4, false);
        this.m_costTextField.setEnabled(false);
        this.m_costTextField.getDocument().addDocumentListener(this);
        ++gbCons.gridx;
        gbCons.fill = 2;
        gbCons.weightx = 1.0;
        gbCons.insets = new Insets(5, 5, 5, 5);
        this.m_propertyPanel.add((Component)this.m_costTextField, gbCons);
        this.m_assignedShiftsPanel = new VWSIMAssignedShiftsPanel();
        this.m_assignedShiftsPanel.init(this.m_propertyData);
        gbCons.gridx = 0;
        ++gbCons.gridy;
        gbCons.fill = 1;
        gbCons.weightx = 1.0;
        gbCons.weighty = 1.0;
        gbCons.gridwidth = 2;
        gbCons.insets = new Insets(5, 5, 5, 5);
        this.m_propertyPanel.add((Component)this.m_assignedShiftsPanel, gbCons);
    }

    private void reinitialize() {
        VWScenarioDefinition def = this.m_propertyData.getScenarioDefinition();
        if (def != null) {
            this.m_typeComboBox.removeActionListener(this);
            this.m_typeComboBox.setSelectedIndex(0);
            this.m_typeComboBox.setEnabled(false);
            this.m_typeComboBox.addActionListener(this);
            this.m_quantityTextField.getDocument().removeDocumentListener(this);
            this.m_quantityTextField.setText("");
            this.m_quantityTextField.setEnabled(false);
            this.m_quantityTextField.getDocument().addDocumentListener(this);
            this.m_costTextField.getDocument().removeDocumentListener(this);
            this.m_costTextField.setText("");
            this.m_costTextField.setEnabled(false);
            this.m_costTextField.getDocument().addDocumentListener(this);
        }
        this.m_resourcesTableModel.reinitialize();
        this.updateTableToolbar();
        this.m_resourcesTable.clearSelection();
        if (this.m_resourcesTableModel.getRowCount() > 0) {
            this.m_resourcesTable.setRowSelectionInterval(0, 0);
        } else {
            this.m_assignedShiftsPanel.setResourceDefinition(null);
        }
    }

    private void updateTableToolbar() {
        this.m_resourcesBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_resourcesBorder.getClientPanel(), 2, Integer.MAX_VALUE));
        this.m_resourcesBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_resourcesBorder.getClientPanel(), 1, 16));
        this.m_resourcesBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_resourcesBorder.getClientPanel(), 1, 65536));
        if (this.m_resourcesTableModel.getRowCount() > 0) {
            this.m_resourcesBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_resourcesBorder.getClientPanel(), 1, Integer.MAX_VALUE));
        }
    }

    private void performTypeComboBoxAction() {
        try {
            int type = 1;
            String typeString = (String)this.m_typeComboBox.getSelectedItem();
            if (VWStringUtils.compare(typeString, VWSIMResource.s_participant) == 0) {
                type = 1;
                this.m_quantityTextField.setText("1");
                this.m_quantityTextField.setEnabled(false);
            } else if (VWStringUtils.compare(typeString, VWSIMResource.s_system) == 0) {
                type = 2;
                this.m_quantityTextField.setEnabled(true);
            } else if (VWStringUtils.compare(typeString, VWSIMResource.s_workgroup) == 0) {
                type = 3;
                this.m_quantityTextField.setEnabled(true);
            }
            int nSelectedRow = this.m_resourcesTable.getSelectedRow();
            this.m_resourcesTableModel.setValueAt(new Integer(type), nSelectedRow, 1);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateQuantityTextField() {
        try {
            String quantity = this.m_quantityTextField.getText();
            Integer quantityValue = new Integer(quantity);
            int value = quantityValue;
            int nSelectedRow = this.m_resourcesTable.getSelectedRow();
            this.m_resourcesTableModel.setValueAt(new Integer(value), nSelectedRow, 2);
        }
        catch (NumberFormatException ex) {
        }
        catch (Exception ex) {
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
            VWDebug.logException(ex);
        }
    }

    private void updateCostTextField() {
        try {
            int nSelectedRow = this.m_resourcesTable.getSelectedRow();
            this.m_resourcesTableModel.setValueAt(new Double(this.m_costTextField.getText()), nSelectedRow, 3);
        }
        catch (NumberFormatException ex) {
        }
        catch (Exception ex) {
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
            VWDebug.logException(ex);
        }
    }
}

